#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>
#include <GL/glaux.h>

static char defaultFile[] = "../data/glass.bmp";
AUX_RGBImageRec *img;

GLint comp;

GLfloat scale[] = {1, 1, 1}, bias[] = {0, 0, 0};
GLboolean changeScale = 1, changeBias = 1;
GLboolean changeR = 1, changeG = 1, changeB = 1;

void init()
	{
	glDrawBuffer(GL_FRONT);
	glReadBuffer(GL_BACK);
	}

void load_img(const char *fname)
	{
	img = auxDIBImageLoad(fname);
	if (!img) 
		{
		fprintf(stderr, "Could not open %s\n", fname);
		exit(1);
		}
	}

void reshape(GLsizei winW, GLsizei winH) 
	{
	glViewport(0, 0, winW, winH);
	glLoadIdentity();
	glOrtho(0, winW, 0, winH, 0, 5);
	}

void draw(void)
	{
	GLenum err;
glPixelStorei(GL_UNPACK_ALIGNMENT,1);

	glPixelTransferf(GL_RED_SCALE, 1);
	glPixelTransferf(GL_GREEN_SCALE, 1);
	glPixelTransferf(GL_BLUE_SCALE, 1);
	glPixelTransferf(GL_RED_BIAS, 0);
	glPixelTransferf(GL_GREEN_BIAS, 0);
	glPixelTransferf(GL_BLUE_BIAS, 0);

	glClear(GL_COLOR_BUFFER_BIT);
	glDrawBuffer(GL_BACK);
	glRasterPos2i(0, 0);
	glDrawPixels(img->sizeX, img->sizeY, GL_RGB, GL_UNSIGNED_BYTE, img->data);

	glPixelTransferf(GL_RED_SCALE, scale[0]);
	glPixelTransferf(GL_GREEN_SCALE, scale[1]);
	glPixelTransferf(GL_BLUE_SCALE, scale[2]);
	glPixelTransferf(GL_RED_BIAS, bias[0]);
	glPixelTransferf(GL_GREEN_BIAS, bias[1]);
	glPixelTransferf(GL_BLUE_BIAS, bias[2]);
	glDrawBuffer(GL_FRONT);
	glCopyPixels(0, 0, img->sizeX, img->sizeY, GL_COLOR);

	err = glGetError();
	
	if (err != GL_NO_ERROR) 
		{
		printf("Error:  %s\n", gluErrorString(err));
		}
	}

void key(unsigned char key, int x, int y)
	{
	char change[][30] = {"Not changing", "Changing"};

	switch(key) 
		{
		case 27:
		exit(0);
		case 's':  case 'S':
			changeScale = (changeScale == 0);
			printf("%s scale\n", change[changeScale]);
		break;
		case 'i':  case 'I':
			changeBias = (changeBias == 0);
			printf("%s bias\n", change[changeBias]);
		break;    
		case 'r':  case 'R':
			changeR = (changeR == 0);
			printf("%s red channel\n", change[changeR]);
		break;
		case 'g':  case 'G':
			changeG = (changeG == 0);
			printf("%s green channel\n", change[changeG]);
		break;
		case 'b':  case 'B':
			changeB = (changeB == 0);
			printf("%s blue channel\n", change[changeB]);
		break;
		case ' ':
			changeScale = changeBias = changeR = changeG = changeB = 1;
			scale[0] = scale[1] = scale[2] = 1;
			bias[0] = bias[1] = bias[2] = 0;
			printf("Resetting all\n");
			draw();
		break;
		case '?':
			printf("Scale:\n");
			printf("\tR:  %f\n", scale[0]);
			printf("\tG:  %f\n", scale[1]);
			printf("\tB:  %f\n", scale[2]);
			printf("Bias:\n");
			printf("\tR:  %f\n", bias[0]);
			printf("\tG:  %f\n", bias[1]);
			printf("\tB:  %f\n\n", bias[2]);
		}
	}

int lastX, lastY, curX, curY;

void idle(void)
	{
	float dScale, dBias;

	if (lastX != curX || lastY != curY) 
		{
		if (changeScale) 
			{
			dScale = (curX - lastX) / (float)img->sizeX;
			if (changeR) scale[0] += dScale;
			if (changeG) scale[1] += dScale;
			if (changeB) scale[2] += dScale;
			}
		if (changeBias) 
			{
			dBias = (curY - lastY) / (float)img->sizeY;
			if (changeR) bias[0] += dBias;
			if (changeG) bias[1] += dBias;
			if (changeB) bias[2] += dBias;
			}      

		glPixelTransferf(GL_RED_SCALE, scale[0]);
		glPixelTransferf(GL_GREEN_SCALE, scale[1]);
		glPixelTransferf(GL_BLUE_SCALE, scale[2]);
		glPixelTransferf(GL_RED_BIAS, bias[0]);
		glPixelTransferf(GL_GREEN_BIAS, bias[1]);
		glPixelTransferf(GL_BLUE_BIAS, bias[2]);

		glRasterPos2i(0, 0);
		glCopyPixels(0, 0, img->sizeX, img->sizeY, GL_COLOR);

		lastX = curX;
		lastY = curY;
		}
	}

void motion(int xpos, int ypos)
	{
	curX = xpos;
	curY = (img->sizeY - ypos);
	}

void button(int button, int state, int xpos, int ypos)
	{
	if (state == GLUT_DOWN) 
		{
		glutIdleFunc(idle); 
		curX = lastX = xpos;
		curY = lastY = (img->sizeY - ypos);
		return;
		} 
	else 
		{
		glutIdleFunc(0);
		}
	}

main(int argc, char *argv[])
	{
	glutInit(&argc, argv);
	load_img(defaultFile);
	glutInitWindowSize(300, 300);
	glutInitWindowPosition(0, 0);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
	glutCreateWindow(argv[0]);
	glutDisplayFunc(draw);
	glutKeyboardFunc(key);
	glutReshapeFunc(reshape);
	glutMouseFunc(button);
	glutMotionFunc(motion);
	init();

	glutMainLoop();
	return 0;
	}

